
import decodeAudio, {decoders} from './audio-decode.js';
import wav from 'audio-lena/wav.js';
import mp3 from 'audio-lena/mp3.js';
import ogg from 'audio-lena/ogg.js';
import flac from 'audio-lena/flac.js';
import opus from 'audio-lena/opus.js';
import t, { is, throws } from 'tst';
import b64 from 'base64-arraybuffer'


//as a callback
t('wav buffer', async function (t) {
	console.time('wav first')
	await decoders.wav()
	console.timeEnd('wav first')

	console.time('wav second')
	let audioBuffer = await decodeAudio(wav)
	console.timeEnd('wav second')
	is(audioBuffer.duration | 0, 12, 'wav duration')
});

t('mp3 buffer', async function (t) {
	console.time('mp3 first')
	await decoders.mp3()
	console.timeEnd('mp3 first')

	console.time('mp3 second')
	let audioBuffer = await decodeAudio(mp3)
	console.timeEnd('mp3 second')
	is(audioBuffer.duration | 0, 12, 'mp3 duration')
});

t('ogg buffer', async function (t) {
	console.time('ogg first')
	let audioBuffer = await decodeAudio(ogg)
	console.timeEnd('ogg first')
	is(audioBuffer.duration | 0, 12, 'ogg duration')

	console.time('ogg second')
	audioBuffer = await decodeAudio(ogg)
	console.timeEnd('ogg second')
	is(audioBuffer.duration | 0, 12, 'ogg duration')
});

t('flac buffer', async function (t) {
	console.time('flac first')
	let audioBuffer = await decodeAudio(flac)
	console.timeEnd('flac first')
	is(audioBuffer.duration | 0, 12, 'flac duration')

	console.time('flac second')
	audioBuffer = await decodeAudio(flac)
	console.timeEnd('flac second')
	is(audioBuffer.duration | 0, 12, 'flac duration')
});

t('opus buffer', async function (t) {
	console.time('opus first')
	let audioBuffer = await decodeAudio(opus)
	console.timeEnd('opus first')
	is(audioBuffer.duration | 0, 12, 'opus duration')

	console.time('opus second')
	audioBuffer = await decodeAudio(opus)
	console.timeEnd('opus second')
	is(audioBuffer.duration | 0, 12, 'opus duration')
});

t('qoa buffer', async function (t) {
	const qoa = b64.decode(`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`)

	console.time('qoa first')
	let audioBuffer = await decodeAudio(qoa)
	console.timeEnd('qoa first')

	console.time('qoa second')
	audioBuffer = await decodeAudio(qoa)
	console.timeEnd('qoa second')
	is(Math.floor(audioBuffer.duration * 100) / 100, 0.82, 'qoa duration')
})

t('malformed data', async t => {
	let log = []
	try {
		let x = await decodeAudio(new Float32Array(10))
	} catch (e) { log.push('arr')}

	try {
		let x = await decodeAudio(null)
	} catch (e) { log.push('null')}

	try {
		let x = await decodeAudio(Promise.resolve())
	} catch (e) { log.push('nonbuf')}

	is(log, ['arr', 'null', 'nonbuf'])
})
